<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 20.01.14 12:08
 */

namespace VM\AdminBundle\Services;

use Doctrine\ORM\EntityManager;
use VM\ApiBundle\Entity\AccountChange;
use VM\ApiBundle\Entity\BankServiceOptions;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyBankServiceOption;
use VM\ApiBundle\Entity\Round;

class ApiCreator
{
    /**
     * @var EntityManager
     */
    protected $EntityManager;
    /**
     * @var ApiGetter
     */
    protected $ApiGetter;


    public function __construct(EntityManager $EntityManager, ApiGetter $ApiGetter)
    {
        $this->EntityManager = $EntityManager;
        $this->ApiGetter = $ApiGetter;
    }


    /**
     * @param Round $Round
     * @param Company $Company
     * @param $value
     * @param string $description
     * @param CompanyBankServiceOption $Account
     * @return AccountChange
     */
    public function createAccountChange(Round $Round, Company $Company, $value, $description = '', CompanyBankServiceOption $Account = null)
    {
        $AccountChange = new AccountChange();
        if($Account === null)
        {
            $Account = $this->ApiGetter->getCompanyCurrentAccount($Company->getId());
        }
        $AccountChange->setCompanyBankServiceOption($Account);
        $AccountChange->setRound($Round);
        $AccountChange->setValue($value);
        $AccountChange->setDescription($description);

        return $AccountChange;
    }


    /**
     * @param CompanyBankServiceOption $CurrentAccount
     * @param Round $Round
     * @param $value
     * @param string $description
     * @return AccountChange
     */
    public function changeAccountValue(CompanyBankServiceOption $CurrentAccount, Round $Round, $value, $description = '')
    {
        $AccountChange = $this->createAccountChange($Round, $CurrentAccount->getCompany(), $value, $description, $CurrentAccount);
        $this->EntityManager->persist($AccountChange);
        $CurrentAccount->setValue($CurrentAccount->getValue() + $value);

        return $AccountChange;
    }


    public function changeCurrentAccountValue($currentAccountId, $value)
    {
        $this->EntityManager->getRepository('VMApiBundle:CompanyBankServiceOption')->changeCurrentAccountValue($currentAccountId, $value);
    }


    /**
     * @param Company $Company
     * @param Round $Round
     * @param BankServiceOptions $BankServiceOption
     * @param $value
     * @param string $description
     * @return CompanyBankServiceOption
     */
    public function createCompanyBankServiceOption(Company $Company, Round $Round, BankServiceOptions $BankServiceOption, $value, $description = '')
    {
        $CompanyBankServiceOption = new CompanyBankServiceOption();
        $CompanyBankServiceOption->setCompany($Company);
        $CompanyBankServiceOption->setRound($Round);
        $CompanyBankServiceOption->setOption($BankServiceOption);
        $CompanyBankServiceOption->setValue($value);
        $CompanyBankServiceOption->setDescription($description);

        $this->EntityManager->persist($CompanyBankServiceOption);
        return $CompanyBankServiceOption;
    }

}